SET NOCOUNT ON

DECLARE @STR_EXEC VARCHAR(2000)

SET @STR_EXEC = 'CREATE '

IF EXISTS(
	SELECT 
		ID 
	FROM 
		SYSOBJECTS 
	WHERE 
		NAME = 'V_TELE_ORC_SEPARADO' AND XTYPE = 'V')
BEGIN
	SET	@STR_EXEC = 'ALTER '
END

	SET @STR_EXEC = @STR_EXEC + 'VIEW [dbo].[V_TELE_ORC_SEPARADO]
			AS
			SELECT A.CD_FILIAL
			     , A.CD_ORC
			     , A.DTHR_PEDIDO
			     , A.ENT_DTHR, DATEDIFF(minute, GETDATE(), A.ENT_DTHR) - C.CONFERENCIA AS PRAZO
			     , ISNULL(A.ENTREGA_BALCAO, 0) AS ENTREGA_BALCAO
			FROM         
				dbo.TELE_ORC AS A INNER JOIN 
				dbo.V_TELE_TEMPO_ETAPA AS C ON A.CD_TIPO_ENTREGA = C.CD_TIPO_ENTREGA AND A.CD_FILIAL = C.CD_FILIAL
			WHERE	
				A.CD_ETAPAS = 2 AND A.CD_TIPO = 2 '	
		
	EXEC (@STR_EXEC)